<label
    @click="form.<?php echo e($name); ?> = '<?php echo e($option->$optionKey); ?>'"
    class="border rounded-md px-2 py-2.5 flex items-center justify-center text-center text-sm font-medium sm:flex-1 cursor-pointer focus:outline-none transition-all"
    :class="[form.<?php echo e($name); ?> == '<?php echo e($option->$optionKey); ?>' ? 'bg-purple border-transparent text-white hover:bg-purple-700' : 'bg-white border-gray-200 text-gray-900 hover:bg-gray-50']"
>
    <input type="radio"
        name="<?php echo e($name); ?>"
        id="<?php echo e($id . '-' . $option->$optionKey); ?>"
        aria-labelledby="radio-<?php echo e($option->$optionKey); ?>"
        <?php if($value): ?>
        value="<?php echo e($value); ?>"
        <?php endif; ?>
        <?php if($disabled): ?>
        disabled="disabled"
        <?php endif; ?>
        <?php if($required): ?>
        required="required"
        <?php endif; ?>
        <?php if($readonly): ?>
        readonly="readonly"
        <?php endif; ?>
        <?php echo e($attributes->except(['placeholder', 'disabled', 'required', 'readonly', 'v-error', 'v-error-message', 'option', 'optionKey', 'optionValue'])); ?>

    />

    <p id="radio-<?php echo e($option->$optionKey); ?>">
        <?php echo e($option->$optionValue); ?>

    </p>
</label>
<?php /**PATH /home1/pmnvir/public_html/acc/resources/views/components/form/input/radio.blade.php ENDPATH**/ ?>